{{-- resources/views/talenta/sandbox/employees/create.blade.php --}}
@extends('layouts.app')
@section('title','Sandbox – Employees')
@section('page-title','Buat Karyawan (Sandbox)')

@section('content')
<div class="max-w-6xl mx-auto">
    {{-- Header Card --}}
    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 px-5 py-4 mb-5 flex items-center justify-between">
        <div>
            <h2 class="text-lg font-semibold text-gray-900">Tambah Karyawan – Sandbox</h2>
            <p class="text-sm text-gray-500">
                Lengkapi informasi personal & employment. Kolom bertanda
                <span class="text-red-600">*</span> wajib diisi.
            </p>
        </div>
        <a href="{{ route('talenta.sandbox.employees.index') }}"
           class="inline-flex items-center gap-2 text-sm px-3 py-2 rounded-xl border border-gray-200 hover:bg-gray-50">
           ← Kembali
        </a>
    </div>

    {{-- Global Errors --}}
    @if($errors->any())
        <div class="mb-5 rounded-xl border border-red-200 bg-red-50 text-red-700 px-4 py-3">
            <div class="font-semibold mb-1">Form belum lengkap</div>
            <ul class="list-disc ml-5 text-sm">
                @foreach($errors->all() as $e)
                    <li>{{ $e }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('talenta.sandbox.employees.store') }}" method="POST" class="space-y-6">
        @csrf

        {{-- ================= PERSONAL ================= --}}
        <section class="bg-white rounded-2xl shadow-sm border border-gray-100">
            <div class="px-5 py-4 border-b border-gray-100">
                <h3 class="font-semibold text-gray-900">Informasi Personal</h3>
                <p class="text-sm text-gray-500">Data dasar karyawan.</p>
            </div>

            <div class="p-5 grid grid-cols-1 md:grid-cols-2 gap-5">
                {{-- Employee ID (required) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Employee ID <span class="text-red-600">*</span>
                    </label>
                    <input type="text" name="employee_id" value="{{ old('employee_id') }}"
                           class="w-full rounded-xl border @error('employee_id') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary"
                           required autocomplete="off" placeholder="mis. EMP0001">
                    @error('employee_id')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                    <p class="text-xs text-gray-500 mt-1">Gunakan format konsisten, contoh: EMP0001.</p>
                </div>

                {{-- First Name (required) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        First Name <span class="text-red-600">*</span>
                    </label>
                    <input type="text" name="first_name" value="{{ old('first_name') }}"
                           class="w-full rounded-xl border @error('first_name') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary"
                           required autocomplete="given-name" placeholder="mis. Budi">
                    @error('first_name')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Last Name (optional) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Last Name</label>
                    <input type="text" name="last_name" value="{{ old('last_name') }}"
                           class="w-full rounded-xl border border-gray-300 px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary"
                           autocomplete="family-name" placeholder="opsional">
                </div>

                {{-- Email (required) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Email <span class="text-red-600">*</span>
                    </label>
                    <input type="email" name="email" value="{{ old('email') }}"
                           class="w-full rounded-xl border @error('email') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary"
                           required autocomplete="email" placeholder="nama@perusahaan.com">
                    @error('email')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Date of Birth (required) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Birthdate* <span class="text-red-600">*</span>
                    </label>
                    <input type="date" name="date_of_birth" value="{{ old('date_of_birth') }}"
                           class="w-full rounded-xl border @error('date_of_birth') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary"
                           required>
                    @error('date_of_birth')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Gender (opsional; controller akan map ke 1/2 jika diisi) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Gender</label>
                    <select name="gender"
                            class="w-full rounded-xl border @error('gender') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary">
                        <option value="">-- Pilih --</option>
                        @foreach(($genders ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" {{ old('gender') == $opt['name'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('gender')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Marital Status (required) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Marital Status <span class="text-red-600">*</span>
                    </label>
                    <select name="marital_status"
                            class="w-full rounded-xl border @error('marital_status') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary"
                            required>
                        <option value="">-- Pilih --</option>
                        @foreach(($maritals ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" {{ old('marital_status') == $opt['name'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('marital_status')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Religion (required) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Religion <span class="text-red-600">*</span>
                    </label>
                    <select name="religion"
                            class="w-full rounded-xl border @error('religion') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary"
                            required>
                        <option value="">-- Pilih --</option>
                        @foreach(($religs ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" {{ old('religion') == $opt['name'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('religion')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>
        </section>

        {{-- ================= EMPLOYMENT ================= --}}
        <section class="bg-white rounded-2xl shadow-sm border border-gray-100">
            <div class="px-5 py-4 border-b border-gray-100">
                <h3 class="font-semibold text-gray-900">Informasi Employment</h3>
                <p class="text-sm text-gray-500">Pemetaan organisasi & status kerja.</p>
            </div>

            <div class="p-5 grid grid-cols-1 md:grid-cols-2 gap-5">
                {{-- Branch (required; kirim nama, controller map ke branch_id) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Branch <span class="text-red-600">*</span>
                    </label>
                    <select name="branch"
                            class="w-full rounded-xl border @error('branch') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary"
                            required>
                        <option value="">-- Pilih --</option>
                        @foreach(($branches ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" {{ old('branch') == $opt['name'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('branch')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Organization (required; kirim nama, controller map ke organization_id) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Organization <span class="text-red-600">*</span>
                    </label>
                    <select name="organization_name"
                            class="w-full rounded-xl border @error('organization_name') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary"
                            required>
                        <option value="">-- Pilih --</option>
                        @foreach(($orgs ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" {{ old('organization_name') == $opt['name'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('organization_name')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Job Position (required; kirim nama -> job_position_id) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Job Position <span class="text-red-600">*</span>
                    </label>
                    <select name="job_position"
                            class="w-full rounded-xl border @error('job_position') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary"
                            required>
                        <option value="">-- Pilih --</option>
                        @foreach(($jobs ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" {{ old('job_position') == $opt['name'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('job_position')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Job Level (required; kirim nama -> job_level_id) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Job Level <span class="text-red-600">*</span>
                    </label>
                    <select name="job_level"
                            class="w-full rounded-xl border @error('job_level') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary"
                            required>
                        <option value="">-- Pilih --</option>
                        @foreach(($levels ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" {{ old('job_level') == $opt['name'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('job_level')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Employment Status (required; kirim nama -> employment_status_id) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Employment Status <span class="text-red-600">*</span>
                    </label>
                    <select name="employment_status"
                            class="w-full rounded-xl border @error('employment_status') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary"
                            required>
                        <option value="">-- Pilih --</option>
                        @foreach(($emps ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" {{ old('employment_status') == $opt['name'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('employment_status')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Join Date (required) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Join Date <span class="text-red-600">*</span>
                    </label>
                    <input type="date" name="join_date" value="{{ old('join_date') }}"
                           class="w-full rounded-xl border @error('join_date') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary"
                           required>
                    @error('join_date')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Schedule (required; kirim nama, controller bebas simpan apa adanya) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Schedule <span class="text-red-600">*</span>
                    </label>
                    <select name="schedule"
                            class="w-full rounded-xl border @error('schedule') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary"
                            required>
                        <option value="">-- Pilih --</option>
                        @foreach(($schedules ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" {{ old('schedule') == $opt['name'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('schedule')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>
        </section>

        {{-- ================= COMPENSATION & TAX ================= --}}
        <section class="bg-white rounded-2xl shadow-sm border border-gray-100">
            <div class="px-5 py-4 border-b border-gray-100">
                <h3 class="font-semibold text-gray-900">Kompensasi & Pajak</h3>
                <p class="text-sm text-gray-500">Isi gaji pokok & status PTKP. Lainnya akan dipakai default di controller.</p>
            </div>

            <div class="p-5 grid grid-cols-1 md:grid-cols-2 gap-5">
                {{-- Basic Salary (required) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Basic Salary <span class="text-red-600">*</span>
                    </label>
                    <input type="number" min="0" step="1" name="basic_salary" value="{{ old('basic_salary') }}"
                           class="w-full rounded-xl border @error('basic_salary') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary"
                           required placeholder="cth: 5000000">
                    @error('basic_salary')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                {{-- PTKP Status (required) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        PTKP Status <span class="text-red-600">*</span>
                    </label>
                    <select name="ptkp_status"
                            class="w-full rounded-xl border @error('ptkp_status') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary"
                            required>
                        <option value="">-- Pilih --</option>
                        @foreach(($ptkps ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" {{ old('ptkp_status') == $opt['name'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('ptkp_status')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            {{-- ❌ Tidak ada hidden defaults yang memaksa nilai. Controller sudah set default aman. --}}
        </section>

        {{-- ================= STICKY ACTIONS ================= --}}
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-4 md:p-5 md:sticky md:bottom-4">
            <div class="flex flex-col md:flex-row items-stretch md:items-center justify-between gap-3">
                <p class="text-sm text-gray-500">
                    Pastikan data sudah benar sebelum disimpan.
                </p>
                <div class="flex items-center gap-3">
                    <a href="{{ route('talenta.sandbox.employees.index') }}"
                       class="inline-flex items-center justify-center px-4 py-2 rounded-xl border border-gray-200 hover:bg-gray-50">
                        Batal
                    </a>
                    <button type="submit"
                            class="inline-flex items-center justify-center px-4 py-2 rounded-xl text-white bg-primary hover:opacity-90">
                        Simpan Karyawan
                    </button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection
